/**************************************************************************************
 
   Copyright (c) Hilscher GmbH. All Rights Reserved.
 
 **************************************************************************************
 
   Filename:
    $Workfile: ProfibusFspmm_Functionlist.h $
   Last Modification:
    @version $Id: ProfibusFspmm_Functionlist.h 18907 2011-08-26 07:20:05Z mark $
   
   Targets:
    Win32/ANSI   : no
    Win32/Unicode: no (define _UNICODE)
    WinCE        : yes
    rcX          : yes
 
   Description:
     
    Profibus Fspmm
    Task function list for configuration file
       
   Changes:
 
     Version    Date        Author
        Description
     ----------------------------------------------------------------------------------
        
**************************************************************************************/
#ifndef __PROFIBUS_FSPMM_FUNCTIONLIST_H
#define __PROFIBUS_FSPMM_FUNCTIONLIST_H

/***************************************************************************************/
/* Profibus Fspmm startup parameter */
#define PROFIBUS_FSPMM_PARAMETER_VERSION_V2    2
typedef struct PROFIBUS_FSPMM_PARAMETER_Ttag {
  struct
  {
    TLR_UINT32 ulTaskIdentifier; /* task identifier see TLR_TaskIdentifier.h*/
    TLR_UINT32 ulParamVersion;   /* structure version  */
  }tPrmHeader;

  TLR_UINT32                  ulCommPackets;   /* Num. of Comm. Packets default 128   */
  TLR_UINT32                  ulUsedXC;
} PROFIBUS_FSPMM_PARAMETER_T;

/***************************************************************************************/
/* Profibus Fspmm startup parameter */
#define PROFIBUS_FSPMM_CALLBACK_API_VERSION    1
typedef struct PROFIBUS_FSPMM_CALLBACK_API_Ttag {
  TLR_UINT32                  ulVersion; 
  TLR_HANDLE                  hIOHandle;
  void (CALLBACK* pfnStartCycleCb)(TLR_HANDLE hHandle);
  void (CALLBACK* pfnEndCycleCb)(TLR_HANDLE hHandle);
  void (CALLBACK* pfnInputCb)(TLR_HANDLE hHandle, TLR_UINT uSlvAddr, TLR_UINT uFlags, TLR_UINT8* ptData, TLR_UINT uLen, TLR_BOOLEAN fSlaveInputsChanged);
  void (CALLBACK* pfnOutputCb)( TLR_HANDLE hHandle, TLR_UINT uSlvAddr, TLR_UINT uFlags, TLR_UINT8* ptData, TLR_UINT* puLen );
} PROFIBUS_FSPMM_CALLBACK_API_T;

/***************************************************************************************/
/* Profibus Fspmm function list, prototyes */

TLR_RESULT  TaskExit_ProfibusFspmm (TLR_VOID FAR* pvRsc);

TLR_RESULT  TaskLeave_ProfibusFspmm(TLR_VOID FAR* pvRsc,
                                             TLR_VOID FAR* pvLve);
                                             
TLR_RESULT  TaskEnter_ProfibusFspmm(TLR_VOID FAR* pvInit);

TLR_RESULT ProfibusFSPMM_RegisterIOCB( TLR_UINT uTskInst, PROFIBUS_FSPMM_CALLBACK_API_T* ptFctApi );


/***************************************************************************************/
#endif /* #ifndef __PROFIBUS_FSPMM_FUNCTIONLIST_H */
